﻿
cd 'C:\1 Suriname\Analysis'   .

GET FILE='01_to_11_Persons.sav'  
   /keep   =  hhid domain gp_subdom domain2  stratum psu psus_N density  urban_66_0 weight  hh_size memberid  age_ok q1_04_new
     q1_02 q1_03  q5_00 q5_01 q5_02  q5_14 q5_15 
     q5_19 q5_20 q5_21 q5_22 q5_23   q5_24 q5_25 q5_26 q5_27 q5_28   .

*************************************************     ID missing answers in the filter questions       **********************************************************************  .

RECODE q5_20 q5_22 q5_24 q5_26 q5_27 (SYSMIS=-1).
EXECUTE.

COMPUTE total_filters=SUM(q5_20,q5_22,q5_24,q5_26).
EXECUTE.

FREQUENCIES VARIABLES=total_filters 
 /ORDER=ANALYSIS.

COMPUTE total_SDR=SUM(q5_21,q5_23,q5_25,q5_28).
EXECUTE.

***2 casos con respuesta de no en la pregunta de medicina y no respuesta en las otras.
***Se supone que las otras también eran de no.

DO IF (q5_26 = 2).
RECODE q5_20 q5_22 q5_24 (-1=2).
END IF.
EXECUTE.

***The  remaining 246 cases have missing values in all cases.  

***make sure all the cases have no value in SRD.

IF  (total_filters = -4 and MISSING(total_SDR)) NO_SDR247=1.
EXECUTE.

FREQUENCIES VARIABLES=NO_SDR247
  /ORDER=ANALYSIS.

***All 246 cases have missing SRD. Use total health estimate for those cases.

DELETE VARIABLES  NO_SDR247  total_SDR  .

MISSING VALUES  q5_20 q5_22 q5_24 q5_26 q5_27 (-1) .

***********************************************    Create consistency between filter and expenditure variables    ***************************************************   .

***If 0 value reported in purchase, change filter to no .

DO IF (q5_21  =  0).
RECODE q5_20 (ELSE=2).
END IF.

DO IF (q5_23  =  0).
RECODE q5_22 (ELSE=2).
END IF.

DO IF (q5_25  =  0).
RECODE q5_24 (ELSE=2).
END IF.

DO IF (q5_28  =  0).
RECODE q5_26 (ELSE=2).
END IF.
EXECUTE.

***If filter indicates no purchase, change zeros to missing.

DO IF (q5_20 = 2).
RECODE q5_21 (0=SYSMIS).
END IF.

DO IF (q5_22 = 2).
RECODE q5_23 (0=SYSMIS).
END IF.

DO IF (q5_24 = 2).
RECODE q5_25 (0=SYSMIS).
END IF.

DO IF (q5_26 = 2).
RECODE q5_28 (0=SYSMIS).
END IF.
EXECUTE.

***If positive value reported in purchase, change filter to Yes.

DO IF (q5_21  >  0).
RECODE q5_20 (ELSE=1).
END IF.

DO IF (q5_23  >  0).
RECODE q5_22 (ELSE=1).
END IF.

DO IF (q5_25  >  0).
RECODE q5_24 (ELSE=1).
END IF.

DO IF (q5_28  >  0).
RECODE q5_26 (ELSE=1).
END IF.
EXECUTE.

***Explore for posible problems 

SORT CASES  BY q5_20.
SPLIT FILE LAYERED BY q5_20.

FREQUENCIES VARIABLES=q5_21
  /ORDER=ANALYSIS.

***OK, 1 case  with  filter =Yes and no consumption, use the same as for outliers

***Explore for posible problems 

SORT CASES  BY q5_22.
SPLIT FILE LAYERED BY q5_22.

FREQUENCIES VARIABLES=q5_23
  /ORDER=ANALYSIS.

***OK, 0 cases   with  filter =Yes and no consumption, use the same as for outliers

***Explore for posible problems 

SORT CASES  BY q5_24.
SPLIT FILE LAYERED BY q5_24.

FREQUENCIES VARIABLES=q5_25
  /ORDER=ANALYSIS.

***OK, 2 cases  with filter =Yes and no consumption, use the same as for outliers

***Explore for posible problems 

***For medicines, if they were adquired at a public facility, and the quantity was missing, change to no purchase.
***The asumption is that there are many other cases receiving public medicines but without any purchase and were
***not reported here because there was no purchase  Since there is no way to know how many (and only 182 cases reported
***public medices at a positive price), a value of 0 and no purchase will be assumed.

SPLIT FILE OFF.

DO IF (MISSING(q5_28) and q5_27 = 2).
RECODE q5_26 (1=2).
END IF.
EXECUTE.

SORT CASES  BY q5_26.
SPLIT FILE LAYERED BY q5_26.

FREQUENCIES VARIABLES=q5_28
  /ORDER=ANALYSIS.

***OK, 10  cases with  filter =Yes and no consumption (9 private and 1 private and public). Use the same as for outliers

SPLIT FILE OFF.

*****************************    identifyID outliers & estimate values for them and cases with missing SRD and filter = Yes     **********************************   .



***   Q5_21   .

***Detect outliers, and with the mising reporting having expenditures.   Estimate  with the average positive values .

COMPUTE percapita = 1 .
COMPUTE var.per = q5_21/ percapita.
COMPUTE by1 = 1.
COMPUTE by2 = domain2.
COMPUTE by1_2=(by1*1000)+by2.
EXECUTE.

SORT CASES BY by1_2 .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=by1_2
  /var.per_mean=MEAN(var.per ) 
  /var.per_sd=SD(var.per ).

COMPUTE SDM=ABS (RND (  (( var.per - var.per_mean)/var.per_sd)   ,0.1) ).
VARIABLE LABELS  SDM 'Standard deviations from the mean (absolute value)'.
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

SORT CASES BY SDM(D).

EXAMINE VARIABLES=SDM BY by1_2
  /PLOT BOXPLOT
  /COMPARE GROUPS
  /STATISTICS NONE
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

***Only 1 case with values above 6 SDM .

IF  (SDM  >= 6  or (q5_20 = 1  and MISSING(q5_21))) ex_q5_21=var.per_mean.
IF  (SDM  >= 6  or (q5_20 = 1  and MISSING(q5_21)))  q5_21=var.per_mean.
EXECUTE.

DELETE VARIABLES   percapita var.per by1 by2 by1_2 var.per_mean var.per_sd SDM  .




***   Q5_23   .

***Detect outliers, and with the mising reporting having expenditures.   Estimate  with the average positive values .

COMPUTE percapita = 1 .
COMPUTE var.per = q5_23/ percapita.
COMPUTE by1 = 1 .
COMPUTE by2 = domain2.
COMPUTE by1_2=(by1*1000)+by2.
EXECUTE.

SORT CASES BY by1_2 .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=by1_2
  /var.per_mean=MEAN(var.per ) 
  /var.per_sd=SD(var.per ).

COMPUTE SDM=ABS (RND (  (( var.per - var.per_mean)/var.per_sd)   ,0.1) ).
VARIABLE LABELS  SDM 'Standard deviations from the mean (absolute value)'.
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

SORT CASES BY SDM(D).

EXAMINE VARIABLES=SDM BY by1_2
  /PLOT BOXPLOT
  /COMPARE GROUPS
  /STATISTICS NONE
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

***Only 0 case with values above 6 SDM .

IF  (SDM  >= 6  or (q5_22 = 1  and MISSING(q5_23))) ex_q5_23=var.per_mean.
IF  (SDM  >= 6  or (q5_22 = 1  and MISSING(q5_23)))  q5_23=var.per_mean.
EXECUTE.

DELETE VARIABLES   percapita var.per by1 by2 by1_2 var.per_mean var.per_sd SDM  .



***   Q5_25   .

***Detect outliers, and with the mising reporting having expenditures.   Estimate  with the average positive values .

COMPUTE percapita = 1 .
COMPUTE var.per = q5_25/ percapita.
COMPUTE by1 = 1 .
COMPUTE by2 = domain2.
COMPUTE by1_2=(by1*1000)+by2.
EXECUTE.

SORT CASES BY by1_2 .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=by1_2
  /var.per_mean=MEAN(var.per ) 
  /var.per_sd=SD(var.per ).

COMPUTE SDM=ABS (RND (  (( var.per - var.per_mean)/var.per_sd)   ,0.1) ).
VARIABLE LABELS  SDM 'Standard deviations from the mean (absolute value)'.
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

SORT CASES BY SDM(D).

EXAMINE VARIABLES=SDM BY by1_2
  /PLOT BOXPLOT
  /COMPARE GROUPS
  /STATISTICS NONE
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

***Only 0 case with values above 6 SDM .

IF  (SDM  >= 6  or (q5_24 = 1  and MISSING(q5_25))) ex_q5_25=var.per_mean.
IF  (SDM  >= 6  or (q5_24 = 1  and MISSING(q5_25)))  q5_25=var.per_mean.
EXECUTE.

DELETE VARIABLES   percapita var.per by1 by2 by1_2 var.per_mean var.per_sd SDM  .



***   Q5_28   .

***Detect outliers, and with the mising reporting having expenditures.   Estimate  with the average positive values .

COMPUTE percapita = 1 .
COMPUTE var.per = q5_28/ percapita.
COMPUTE by1 = 1 .

RECODE q5_27 (1=1) (2 thru 3=2) INTO by2.
EXECUTE.

COMPUTE by1_2=(by1*1000)+by2.
EXECUTE.

SORT CASES BY by1_2 .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=by1_2
  /var.per_mean=MEAN(var.per ) 
  /var.per_sd=SD(var.per ).

COMPUTE SDM=ABS (RND (  (( var.per - var.per_mean)/var.per_sd)   ,0.1) ).
VARIABLE LABELS  SDM 'Standard deviations from the mean (absolute value)'.
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

SORT CASES BY SDM(D).

EXAMINE VARIABLES=SDM BY by1_2
  /PLOT BOXPLOT
  /COMPARE GROUPS
  /STATISTICS NONE
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

***  3 case with values above 6 SDM .

IF  (SDM  >= 6  or (q5_26 = 1  and MISSING(q5_28))) ex_q5_28=var.per_mean.
IF  (SDM  >= 6  or (q5_26 = 1  and MISSING(q5_28)))  q5_28=var.per_mean.
EXECUTE.

DELETE VARIABLES   percapita var.per by1 by2 by1_2 var.per_mean var.per_sd SDM  .

*****************          Estimate the totals for each person and give values to the cases with missing values in the filter and the quantity      *******************.

RECODE q5_21 q5_23 q5_25 q5_28 ex_q5_21 ex_q5_23 ex_q5_25 ex_q5_28 (MISSING=0).
EXECUTE.

COMPUTE t_hea_pe=12 * (q5_21+q5_23+q5_25+q5_28 ).
VARIABLE LABELS  t_hea_pe 'Total anual health expenditures per person'.

COMPUTE ex_t_hea_pe= 12 * (ex_q5_21+ex_q5_23+ex_q5_25+ex_q5_28 ) .
VARIABLE LABELS  ex_t_hea_pe 'Estimated total anual health expenditures per person'.
EXECUTE.

***Estimate total values .

COMPUTE percapita = 1 .
COMPUTE var.per = t_hea_pe/ percapita.
COMPUTE by1 = 1 .
COMPUTE by2 = domain2.
COMPUTE by1_2=(by1*1000)+by2.
EXECUTE.

SORT CASES BY by1_2 .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=by1_2
  /var.per_mean=MEAN(var.per ) 
  /var.per_sd=SD(var.per ).

***use the average for the cases with missing in all the filters and no value in the quantities .

IF  (total_filters = -4 and t_hea_pe=0) ex_t_hea_pe=var.per_mean.
IF  (total_filters = -4 and t_hea_pe=0) t_hea_pe=var.per_mean.
EXECUTE.

DELETE VARIABLES percapita var.per by1 by2 by1_2 var.per_mean var.per_sd   .

FILTER OFF.
USE ALL.
EXECUTE.

SORT CASES BY hhid(A) memberid(A).

SAVE OUTFILE='c Health_1.sav'
  /COMPRESSED.

******************.

GET  FILE='c Health_1.sav'.

***Add the totals for each households


AGGREGATE
  /OUTFILE= *
  /BREAK=hhid
  /heal1=SUM(t_hea_pe) 
  /heal1_ex=SUM(ex_t_hea_pe).

format heal1  heal1_ex (comma8.2) .

VARIABLE LABELS  heal1 'Total anual health expenditures (M5) / HH / year'.

VARIABLE LABELS  heal1_ex 'Estimated total anual health expenditures (M5) / HH / year'.

SAVE OUTFILE='c Health_2.sav'
  /COMPRESSED.

******************.

GET  FILE='c Health_2.sav'.


****** edu1  food1  heal1 



